/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.rbf.RbfErrorDetail;
import com.ibm.hwmca.fw.rbf.RbfException;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.impl.AbortThread;
import com.ibm.hwmca.fw.rbf.impl.HandlerPreparer;
import com.ibm.hwmca.fw.rbf.impl.OfferReply;
import com.ibm.hwmca.fw.rbf.impl.QueryTask;
import com.ibm.hwmca.fw.rbf.impl.RbfMsg;
import com.ibm.hwmca.fw.rbf.impl.RbfReply;
import com.ibm.hwmca.fw.rbf.impl.RbfUtils;
import com.ibm.hwmca.fw.rbf.impl.RequestManager;
import com.ibm.hwmca.fw.rbf.impl.RequestTrackingData;
import com.ibm.hwmca.fw.rbf.impl.ResultReporter;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

class OfferMsg
implements RbfMsg {
    private static final String TRACE_MASKT = "XRBFOMST";
    private static final String TRACE_MASKF = "XRBFOMSF";
    private static final String TRACE_MASKD = "XRBFOMSD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RBF-OfferMsg");
    private static final long serialVersionUID = 3507214929034204859L;
    private RbfRequestId requestId;
    private int status;
    private RbfErrorDetail errorDetail;
    static final int STATUS_READY_TO_HANDLE = 0;
    static final int STATUS_NOT_CAPABLE = 4;
    static final int STATUS_INTERNAL_ERROR = 8;
    static final int STATUS_APPLICATION_ERROR = 12;

    OfferMsg(RbfRequestId requestId, int status) {
        this(requestId, status, null);
    }

    OfferMsg(RbfRequestId requestId, int status, RbfErrorDetail errorDetail) {
        if (requestId == null) {
            throw new IllegalArgumentException("Null request identifier specified");
        }
        if (!this.isValidStatus(status)) {
            throw new IllegalArgumentException("Invalid status specified");
        }
        this.requestId = requestId;
        this.status = status;
        this.errorDetail = errorDetail;
        Trace.trace(TRACE_MASKT, "<> " + this.toString());
    }

    private boolean isValidStatus(int status) {
        switch (status) {
            case 0: {
                return true;
            }
            case 4: {
                return true;
            }
            case 8: {
                return true;
            }
            case 12: {
                return true;
            }
        }
        return false;
    }

    RbfRequestId getRequestId() {
        return this.requestId;
    }

    int getStatus() {
        return this.status;
    }

    RbfErrorDetail getErrorDetail() {
        return this.errorDetail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RbfReply process(MachineId sender2, int protocol) {
        Trace.trace(TRACE_MASKT, "-> process()");
        OfferReply reply = null;
        RbfRequest request = RbfRequest.getRequest(this.requestId);
        if (request == null) {
            reply = new OfferReply(this.requestId, 4);
            Trace.trace(TRACE_MASKF, "Request no longer managed");
            Trace.trace(TRACE_MASKT, "<- process()");
            return reply;
        }
        RequestTrackingData trackingData = request.getTrackingData();
        Object object = trackingData.offerLock;
        synchronized (object) {
            if (!this.isGoodOffer(request, sender2, protocol)) {
                reply = new OfferReply(this.requestId, 4);
                Trace.trace(TRACE_MASKT, "<- process()");
                return reply;
            }
            boolean shouldHandle = false;
            try {
                shouldHandle = this.shouldHandleRequest(request);
            }
            catch (Exception e) {
                reply = new OfferReply(this.requestId, 4);
                Trace.trace(TRACE_MASKT, "<- process()");
                return reply;
            }
            reply = this.generateReply(request, sender2, shouldHandle);
            Trace.trace(TRACE_MASKT, "<- process()");
            return reply;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGoodOffer(RbfRequest request, MachineId sender2, int protocol) {
        RequestTrackingData trackingData;
        boolean isGoodOffer = false;
        RequestTrackingData requestTrackingData = trackingData = request.getTrackingData();
        synchronized (requestTrackingData) {
            if (!trackingData.isHandlerNeeded()) {
                return false;
            }
            if (trackingData.isAborting(sender2)) {
                return false;
            }
            trackingData.removePreparing(sender2);
            if (!this.isValidStatus(this.status)) {
                String desc = "Internal error: Invalid offer status (" + this.status + ") received from " + RbfUtils.getMachineInfo(sender2) + " using protocol " + protocol + " " + this.requestId;
                Trace.trace(TRACE_MASKF, desc);
                FrameworkLog fl = new FrameworkLog(classLogInfo, 1060);
                fl.add(desc);
                fl.add(RbfUtils.getLoggingInfo(request));
                fl.log();
                trackingData.addUnusable(sender2);
                trackingData.errorResultCode = 8;
                trackingData.errorDetail = new RbfErrorDetail(1060, desc);
                HandlerPreparer.prepareHandlers(request);
            } else if (this.status == 0) {
                trackingData.setHandler(sender2);
                trackingData.handlerOutage = false;
                trackingData.redrive = false;
                trackingData.errorDetail = null;
                trackingData.errorResultCode = 0;
                isGoodOffer = true;
            } else if (this.status == 4) {
                trackingData.addUnusable(sender2);
                trackingData.notCapableOffer = true;
                HandlerPreparer.prepareHandlers(request);
            } else if (this.status == 8) {
                trackingData.addUnusable(sender2);
                trackingData.errorDetail = this.errorDetail;
                trackingData.errorResultCode = 8;
                HandlerPreparer.prepareHandlers(request);
            } else {
                trackingData.addUnusable(sender2);
                trackingData.errorDetail = this.errorDetail;
                trackingData.errorResultCode = 12;
                HandlerPreparer.prepareHandlers(request);
            }
        }
        return isGoodOffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldHandleRequest(RbfRequest request) throws Exception {
        RbfErrorDetail lclErrorDetail = null;
        RequestTrackingData trackingData = request.getTrackingData();
        boolean shouldHandle = false;
        String callDescription = request.getClass().getName() + ".shouldBeHandled() " + this.requestId;
        Trace.trace(TRACE_MASKF, "-> " + callDescription);
        try {
            shouldHandle = request.shouldBeHandled();
        }
        catch (Exception e) {
            String desc = "Uncaught exception from " + request.getClass().getName() + ".shouldBeHandled() " + this.requestId + ":\n" + RbfUtils.getStackTrace(e);
            Trace.trace(TRACE_MASKF, desc);
            FrameworkLog fl = new FrameworkLog(classLogInfo, 1059);
            fl.add(desc);
            fl.add(RbfUtils.getLoggingInfo(request));
            fl.log();
            RequestTrackingData requestTrackingData = trackingData;
            synchronized (requestTrackingData) {
                int state = trackingData.getState();
                if (state == 4 || state == 8) {
                    if (trackingData.preparing != null && !trackingData.preparing.isEmpty()) {
                        trackingData.addAborting(trackingData.preparing);
                        this.abortAsync(request, new HashSet(trackingData.preparing), 12);
                        trackingData.preparing.clear();
                    }
                    lclErrorDetail = new RbfErrorDetail(1059, desc);
                    this.reportAndClose(request, 12, lclErrorDetail);
                }
            }
            throw e;
        }
        Trace.trace(TRACE_MASKF, "<- " + callDescription);
        Trace.trace(TRACE_MASKF, "shouldBeHandled()=" + shouldHandle + " for " + RbfUtils.getMachineInfo(trackingData.handler));
        return shouldHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OfferReply generateReply(RbfRequest request, MachineId sender2, boolean shouldHandle) {
        RequestTrackingData trackingData;
        OfferReply offerReply = null;
        RbfErrorDetail lclErrorDetail = null;
        RequestTrackingData requestTrackingData = trackingData = request.getTrackingData();
        synchronized (requestTrackingData) {
            int state = trackingData.getState();
            if (state != 4 && state != 8) {
                offerReply = trackingData.canceled ? new OfferReply(this.requestId, 6) : new OfferReply(this.requestId, 4);
            } else if (shouldHandle) {
                try {
                    trackingData.state = 8;
                    if (trackingData.preparing != null && !trackingData.preparing.isEmpty()) {
                        trackingData.addAborting(trackingData.preparing);
                        this.abortAsync(request, new HashSet(trackingData.preparing), 0);
                        trackingData.preparing.clear();
                    }
                    try {
                        RequestManager requestMgr = RequestManager.getRequestManager();
                        requestMgr.changed(request);
                        if (trackingData.queryTask == null) {
                            QueryTask queryTask;
                            trackingData.queryTask = queryTask = new QueryTask(this.requestId);
                            Timer queryTimer = QueryTask.getTimer();
                            queryTimer.schedule((TimerTask)queryTask, 300000L, 300000L);
                        }
                        offerReply = new OfferReply(request, 0);
                    }
                    catch (RbfException rbfe) {
                        String desc = "Internal error:\n" + RbfUtils.getStackTrace(rbfe);
                        lclErrorDetail = new RbfErrorDetail(1061, desc);
                        this.reportAndClose(request, 8, lclErrorDetail);
                        offerReply = new OfferReply(this.requestId, 4);
                    }
                }
                catch (PersistenceException pe) {
                    if (trackingData.preparing != null && !trackingData.preparing.isEmpty()) {
                        trackingData.addAborting(trackingData.preparing);
                        this.abortAsync(request, new HashSet(trackingData.preparing), 12);
                        trackingData.preparing.clear();
                    }
                    String desc = pe.getClass().getName() + " encoding " + request.getBody().getClass().getName() + ":\n" + RbfUtils.getStackTrace(pe);
                    lclErrorDetail = new RbfErrorDetail(1056, desc);
                    this.reportAndClose(request, 4, lclErrorDetail);
                    offerReply = new OfferReply(this.requestId, 4);
                }
            } else {
                trackingData.state = 12;
                trackingData.addHistory("Canceled by shouldBeHandled() method");
                if (trackingData.preparing != null && !trackingData.preparing.isEmpty()) {
                    trackingData.addAborting(trackingData.preparing);
                    this.abortAsync(request, new HashSet(trackingData.preparing), 4);
                    trackingData.preparing.clear();
                }
                this.reportAndClose(request, 40, null);
                offerReply = new OfferReply(this.requestId, 6);
            }
        }
        return offerReply;
    }

    private void reportAndClose(RbfRequest request, int statusCode, Object details) {
        ResultReporter.reportAndClose(request, statusCode, details);
    }

    private void abortAsync(RbfRequest request, Set targets, int status) {
        if (!targets.isEmpty()) {
            AbortThread abortThread = new AbortThread(request, targets, status);
            abortThread.start();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[OfferMsg: reqId=" + this.requestId + ", status=" + this.status + "]");
        return sb.toString();
    }
}

